//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace CLRUnleashed
{
	public struct Point
	{
		// Zdarzenie uywane przez klienta w celu powiadomienia
		// o zmianie elementw listy:
		private int x;
		private int y;
		public Point(int x, int y)
		{
			this.x = x;
			this.y = y;
		}
		public int X
		{
			get
			{
				return x;
			}
			set
			{
				x = value;
			}
		}
		public int Y
		{
			get
			{
				return y;
			}
			set
			{
				y = value;
			}
		}
		public Point Coordinate
		{
			get
			{
				return this;
			}
			set
			{
				x = value.x;
				y = value.y;
			}
		}
	}
	/// <summary>
	/// Podsumowanie dla Properties.
	/// </summary>
	class Properties
	{
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			Point p = new Point(1, 2);
			Console.WriteLine("X: {0} Y: {1}", p.X, p.Y);
		}
	}
}
